﻿using System;
using System.Web;

namespace VIRP_WEB.Custom.EFR
{
    public partial class PatientRelatedLabTests : EfrBasePage
    {
        private int patientId;

        protected override void Page_Load(object sender, EventArgs e)
        {
            ReplacePageTitle();

            if (!IsPostBack)
            {
                var patientSummary = GetOrStorePatientSummary();
                if (patientSummary != null)
                {
                    LabelPatientName.Text = patientSummary.FullName;
                    LabelPatientSnum.Text = patientSummary.Snum;

                    ReplacePageTitle("Patients > Patient Lookup > Related Lab Tests > " + patientSummary.FullName);
                }

                LoadData();
            }
        }

        private void LoadData()
        {
            ObjectDataSourceRelatedLabTests.SelectParameters["CURRENT_USER"].DefaultValue = HttpContext.Current.User.Identity.Name;
            ObjectDataSourceRelatedLabTests.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = UserSession.CurrentRegistryId.ToString();
            ObjectDataSourceRelatedLabTests.Select();
        }

        protected void LinkButtonPatientInformation_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
                Response.Redirect(string.Format("~/Custom/EFR/Patients/Patient.aspx?PatientId={0}", patientId), false);
        }

        protected void LinkButtonWorkflows_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
                Response.Redirect(string.Format("~/Custom/EFR/Patients/PatientWorkflows.aspx?PatientId={0}", patientId), false);
        }

        protected void LinkButtonRelatedDiagnoses_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
                Response.Redirect(string.Format("~/Custom/EFR/Patients/PatientRelatedDiagnoses.aspx?PatientId={0}", patientId), false);
        }

        protected void LinkButtonImages_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
                Response.Redirect(string.Format("~/Custom/EFR/Patients/PatientImaging.aspx?PatientId={0}", patientId), false);
        }
    }
}